/*
 * Created on 3/25/2016
 *
 */
package gov.va.med.esr.common.persistent.comms;

import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType.Code;
import gov.va.med.esr.common.model.party.Address;


import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;


/**
 * @author DNS   faulkj
 */
public interface CorrespondenceDAO extends DAOOperations
{
	public static final String FIND_ADDRESS_H_ID = "CorrespondenceQuery_findAddressHIdByPersonId";
	public static final String PARAM_PERSON_ID = "personId";
	public static final String PARAM_FORM_ID = "formId";
	public static final String PARAM_CORR_ID = "correspondenceId";

	public static final String PARAM_STATUS_ID = "statusId";
	public static final String FIND_BY_FORM_AND_STATUS = "CorrespondenceQuery_findPendingByFormNumber";
	public static final String FIND_SENT_BY_FORM_AND_STATUS = "CorrespondenceQuery_findSentByFormNumber";
	public static final String FIND_BY_FORMS = "CorrespondenceQuery_findAllByFormNumber";
	public static final String FIND_BY_ID = "CorrespondenceQuery_findById";



	public List<Correspondence> findCorrespondenceByPersonId(String personId) throws DAOException;

	public ArrayList<Correspondence> findPendingCorrespondenceByForm(BigDecimal personId, String formId) throws DAOException;

	public ArrayList<Correspondence> findSentCorrespondenceByForm(BigDecimal personId, String formId) throws DAOException;

	public ArrayList<Correspondence> findAllCorrespondenceByForm(BigDecimal personId, String formId) throws DAOException;

    public BigDecimal findAddressHistoryIdByPersonId(BigDecimal personId) throws DAOException;

    public Correspondence findById(BigDecimal correspondenceId) throws DAOException;

    public Address getHistoricalAddress(BigDecimal addressHId) throws DAOException;




}
