/*
 * Created on Sep 27, 2004
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package gov.va.med.esr.common.persistent.comms;

import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.MailingStatusLink;
import gov.va.med.esr.common.model.comms.HecRejectReason;
import gov.va.med.esr.common.model.comms.CommsLogSearchQueryInfo;


import java.util.List;

import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.DAOOperations;


/**
 * @author DNS   TSAIG
 */
public interface CommsLogEntryDAO extends DAOOperations
{
    public CommsLogEntry findCommsLogEntryByBarcode(String barcode) throws DAOException;

    public List findCommsLogListByPersonId(String personId) throws DAOException;

    public void update(CommsLogEntry log)  throws DAOException;
    
    public void merge(CommsLogEntry log)  throws DAOException;

    public void insert(CommsLogEntry log)  throws DAOException;

    public void insertMailingStatus(MailingStatusLink mailStat)  throws DAOException;

    public void insertHecRejectReason(HecRejectReason rejReason)  throws DAOException;
    
    /**
     * Finds a list of CommsLogEntry objects based on the passed in search criteria.
     *
     * @param searchQueryInfo The search query information
     * @return The list of CommsLogEntry objects
     * @throws DAOException if there were any problems retrieving the data
     * @throws MaxRecordsExceededException if too many records matches the criteria
     */
    public List find(CommsLogSearchQueryInfo searchQueryInfo) throws DAOException,
        MaxRecordsExceededException;
    
    // 3.6 CCR 10960 - removed all references to HANDBOOK.  They have been moved the HandBookDAO 
}
