/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.model.security;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.security.RolePrincipal;
import gov.va.med.fw.security.UserPrincipal;

/**
 * UserRole is a link Class that holds the mapping of UserPrincipal to ESRRolePrincipal.
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public class UserRole extends AbstractKeyedEntity {
   
   /**
    * An instance of serialVersionUID 
    */
   private static final long serialVersionUID = 151499109172824161L;

   private UserPrincipal userPrincipal = null;

   private RolePrincipal rolePrincipal = null;

   /**
    * Default Constructor
    */
   private UserRole() {
      super();
   }

   /**
    * Construct using UserPrincipal and RolePrincipal.
    * 
    * @param userPrincipal
    * @param rolePrincipal
    */
   public UserRole(UserPrincipal userPrincipal, RolePrincipal rolePrincipal) {
      Validate.notNull(userPrincipal, "UserPrincipal can not be null in UserRole");
      Validate.notNull(rolePrincipal, "RolePrincipal can not be null in UserRole");
      this.userPrincipal = userPrincipal;
      this.rolePrincipal = rolePrincipal;
   }

   public RolePrincipal getRolePrincipal() {
      return rolePrincipal;
   }

   private void setRolePrincipal(RolePrincipal rolePrincipal) {
      this.rolePrincipal = rolePrincipal;
   }

   public UserPrincipal getUserPrincipal() {
      return userPrincipal;
   }

   private void setUserPrincipal(UserPrincipal userPrincipal) {
      this.userPrincipal = userPrincipal;
   }

   /**
    * @see gov.va.med.fw.model.AbstractKeyedEntity#finalize()
    */
   protected void finalize() throws Throwable {
      super.finalize();
      this.setUserPrincipal( null );
      this.setRolePrincipal( null );
   }
}