/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.model.security;

import java.util.Date;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.security.UserPrincipal;

/**
 * A class required in mapping to store the user login history.
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public class UserLogin extends AbstractKeyedEntity {

   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = 3884248614821573914L;

   private UserPrincipal userPrincipal = null;

   private Date successfulLoginDate = null;

   private Date failedLoginDate = null;

   /**
    * Default Constructor
    */
   private UserLogin() {
      super();
   }

   /**
    * Construct using user, successful login date and failed login date. Only one date is
    * required every time depending upon whether its being generated a successful login
    * time or failed login time.
    * 
    * @param userPrincipal
    * @param successfulLoginDate
    * @param failedLoginDate
    */
   public UserLogin(UserPrincipal userPrincipal, Date successfulLoginDate,
         Date failedLoginDate) {
      this.userPrincipal = userPrincipal;
      this.successfulLoginDate = successfulLoginDate;
      this.failedLoginDate = failedLoginDate;
   }

   public UserPrincipal getUserPrincipal() {
      return userPrincipal;
   }

   private void setUserPrincipal(UserPrincipal userPrincipal) {
      this.userPrincipal = userPrincipal;
   }

   private void setFailedLoginDate(Date failedLoginDate) {
      this.failedLoginDate = failedLoginDate;
   }

   private void setSuccessfulLoginDate(Date successfulLoginDate) {
      this.successfulLoginDate = successfulLoginDate;
   }

   public Date getFailedLoginDate() {
      return failedLoginDate;
   }

   public Date getSuccessfulLoginDate() {
      return successfulLoginDate;
   }

   /**
    * @see gov.va.med.fw.model.AbstractKeyedEntity#finalize()
    */
   protected void finalize() throws Throwable {
      super.finalize();
      setUserPrincipal( null );
      setFailedLoginDate( null );
      setSuccessfulLoginDate( null );
   }
}