/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.security;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.AbstractKeyedEntity;

public class UserCapabilitySet extends AbstractKeyedEntity {

    private static final long serialVersionUID = 816682594062507512L;
    
    private CapabilitySet capabilitySet = null;
    private ESRUserPrincipalImpl userPrincipal = null;
    
    public UserCapabilitySet() {
            super();
    }
        
    public UserCapabilitySet(ESRUserPrincipalImpl userPrincipal, 
            CapabilitySet capabilitySet) {
        Validate.notNull(capabilitySet, "CapabilitySet can not be null in UserCapabilitySet");
        Validate.notNull(userPrincipal, "UserPrincipal can not be null in UserCapabilitySet");       
        
        this.capabilitySet = capabilitySet;
        this.userPrincipal = userPrincipal;        
    }
    
    public CapabilitySet getCapabilitySet() {
        return capabilitySet;
    }
    public void setCapabilitySet(CapabilitySet capabilitySet) {
        this.capabilitySet = capabilitySet;
    }
    public ESRUserPrincipalImpl getUserPrincipal() {
        return userPrincipal;
    }
    public void setUserPrincipal(ESRUserPrincipalImpl userPrincipal) {
        this.userPrincipal = userPrincipal;
    }
}
