/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.security;

import java.util.Date;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;

import gov.va.med.esr.common.model.lookup.Capability;

public class UserCapability extends AbstractKeyedEntity implements Comparable{

    private static final long serialVersionUID = -2136807781054356615L;
    
    private Capability capability = null;
    private ESRUserPrincipal userPrincipal = null;
    private Date activeDate = null;
    private Date inactiveDate = null;
    private Date oldActiveDate = null;
    private Date oldInactiveDate = null;
    
    public UserCapability() {
        super();
    }
    
    public UserCapability(ESRUserPrincipalImpl userPrincipal, 
            Capability capability, Date activeDate, Date inactiveDate) {
        Validate.notNull(userPrincipal, "UserPrincipal can not be null in UserCapability");
        Validate.notNull(capability, "Capability can not be null in UserCapability");       
        this.userPrincipal = userPrincipal;
        this.capability = capability;
        this.activeDate = activeDate;
        this.inactiveDate = inactiveDate;
    }

    public Capability getCapability() {
        return capability;
    }

    public void setCapability(Capability capability) {
        this.capability = capability;
    }

    public ESRUserPrincipal getUserPrincipal() {
        return userPrincipal;
    }

    public void setUserPrincipal(ESRUserPrincipal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }
        
    public Date getActiveDate() {
        return activeDate;
    }

    public void setActiveDate(Date activeDate) {
        this.activeDate = activeDate;
    }

    public Date getInactiveDate() {
        return inactiveDate;
    }

    public void setInactiveDate(Date inactiveDate) {
        this.inactiveDate = inactiveDate;
    }

    public Date getOldActiveDate() {
        return this.oldActiveDate;
    }

    public Date getOldInactiveDate() {
        return this.oldInactiveDate;
    }

    private void setOldActiveDate(Date oldActiveDate) {
        this.oldActiveDate = oldActiveDate;
    }

    private void setOldInactiveDate(Date oldInactiveDate) {
        this.oldInactiveDate = oldInactiveDate;
    }

    public boolean isActive() {
        return AbstractPermission.isAssignable(activeDate, inactiveDate);
    }
    public int compareTo(Object o) {
        if (o != null && o instanceof UserCapability) {
            UserCapability other = (UserCapability) o;
            if (getCapability() != null && other.getCapability() != null) {
                return getCapability().compareTo(other.getCapability());
            }
        }
        return 1;
    }       
}
