/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.security;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.AbstractKeyedEntity;

public class RoleCapabilitySet extends AbstractKeyedEntity {
    private static final long serialVersionUID = 4251388077363758757L;
    
    private CapabilitySet capabilitySet = null;
    private ESRRolePrincipalImpl rolePrincipal = null;
    
    public RoleCapabilitySet() {
            super();
    }
        
    public RoleCapabilitySet(ESRRolePrincipalImpl rolePrincipal, 
            CapabilitySet capabilitySet) {
        Validate.notNull(capabilitySet, "CapabilitySet can not be null in UserCapabilitySet");
        Validate.notNull(rolePrincipal, "ESRRolePrincipalImpl can not be null in UserCapabilitySet");       
        
        this.capabilitySet = capabilitySet;
        this.rolePrincipal = rolePrincipal;        
    }
    
    public CapabilitySet getCapabilitySet() {
        return capabilitySet;
    }
    public void setCapabilitySet(CapabilitySet capabilitySet) {
        this.capabilitySet = capabilitySet;
    }
    public ESRRolePrincipalImpl getRolePrincipal() {
        return rolePrincipal;
    }
    public void setRolePrincipal(ESRRolePrincipalImpl rolePrincipal) {
        this.rolePrincipal = rolePrincipal;
    }
}
