/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.security;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.Capability;

public class RoleCapability extends AbstractKeyedEntity {
    private static final long serialVersionUID = -8841785240492113427L;
    private Capability capability = null;
    private ESRRolePrincipalImpl rolePrincipal = null;
   
    public RoleCapability() {
        super();
    }
    
    public RoleCapability(ESRRolePrincipalImpl rolePrincipal, 
            Capability capability) {
        Validate.notNull(rolePrincipal, "RolePrincipal can not be null in RoleCapability");
        Validate.notNull(capability, "Capability can not be null in RoleCapability");       
        this.rolePrincipal = rolePrincipal;
        this.capability = capability;
    }

    public Capability getCapability() {
        return capability;
    }

    public void setCapability(Capability capability) {
        this.capability = capability;
    }

    public ESRRolePrincipal getRolePrincipal() {
        return rolePrincipal;
    }

    public void setRolePrincipal(ESRRolePrincipalImpl rolePrincipal) {
        this.rolePrincipal = rolePrincipal;
    }
}
