/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.security;

import java.util.Date;
import java.util.Set;

import gov.va.med.fw.security.UserPrincipal;

/**
 * UserPrincipal is a UserPrincipal that provides methods to access
 * the user profile and account related information that is specific to ESR project.
 * 
 * @author DNS   MANSOG
 * @version 1.0
 */
public interface ESRUserPrincipal
    extends UserPrincipal {

    /**
     * First name of the user
     * @return String - given name of a user
     */
    public String getFullName();

    /**
     * @return count of failed login attempts.
     */
    public int getFailAttemptCount();

    /**
     * @return Date - date account was last accessed
     */
    public Date getLastAccessDate();

    /**
     * Returns the date since when this account is inactive (disabled).
     * If the account is active (enabled), returns null value.
     * @return Date
     */
    public Date getInActiveDate();

    /**
     * Returns the date the date this account is logined in the very first time
     * @return Date
     */
    public Date getInitialLoginDate();
    
    /**
     * Date when the account is locked. Null value indicates not locked.
     * @return Date account is locked.
     */
    public Date getLockDate();

    /**
     * Date of account password changed.
     * @return
     */
    public Date getPasswordChangeDate();

    /**
     * Is it time to display password change warning
     * @return
     */
    public boolean isPasswordChangeWarningDays();
    
    /**
     * No of days remaining before the password would be expired.
     * @return int - no of days
     */
    public int getDaysRemainingToExpirePassword();
    
    /**
     * Password is suspdended after this date
     * @return
     */
    public Date getPasswordSuspendDate();
    
    /**
     * Password is expired after this date irrespective if when the loat login was
     * @return
     */
    public Date getPasswordExpireDate();
    
    /**
     * Gets the Capability objects.
     * @return
     */
    public Set getCapabilities();
}