package gov.va.med.esr.common.model.security;

import gov.va.med.fw.model.AbstractKeyedEntity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;

public class EEServiceUser extends AbstractKeyedEntity {


	private static final long serialVersionUID =1L;
	
	private String userName;
	private String password;
	private String contactName;
	private String contactPhone;
	private boolean active;
	
	private Set eeServiceUserRequests;
	
	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	  public String getContactName() {
	       
	        return contactName;
	    }

	    public void setContactName(String contactName) {
	        this.contactName = contactName;
	    }
	    public String getContactPhone() {
	        
	        return contactPhone;
	    }

	    public void setContactPhone(String contactPhone) {
	        this.contactPhone = contactPhone;
	    }
	    public boolean getActive() {
	        return this.active;
	    }

	    public void setActive( boolean active) {
	        this.active=active;
	    }
	public String getPassword() {
		return this.password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	

    public void setIdentifier(Serializable identifier) {
        super.setIdentifier(identifier);
    }

    public Serializable getIdentifier() {
        return super.getIdentifier();
    }



	public Set getEeServiceUserRequests() {
		return eeServiceUserRequests;
	}

	public void setEeServiceUserRequests(Set eeServiceUserRequests) {
		this.eeServiceUserRequests = eeServiceUserRequests;
	}
	
	public void addEEServiceUserRequest(EEServiceRequestLite eeServiceRequestLite) {
		if ( eeServiceUserRequests == null ) {
			eeServiceUserRequests = new HashSet();
		}
		EEServiceUserRequest userRequest = new EEServiceUserRequest();
		userRequest.setEeServiceRequestLite(eeServiceRequestLite);
		eeServiceUserRequests.add(userRequest);
		userRequest.setEeServiceUser(this);
	}
	public void removeAllEEServiceUserRequest() {
		
		this.eeServiceUserRequests = new HashSet();
	}

	public void removeRequest(EEServiceUserRequest eeServiceRequest ) {
		boolean test = this.eeServiceUserRequests.remove(eeServiceRequest);
		System.out.println("removing eeServiceRequest:" + eeServiceRequest.getEeServiceRequestLite().getName() + "test:" + test);
	}
	
	public void removeRequests(Set eeServiceRequest ) {
		if (eeServiceRequest != null && eeServiceRequest.size() <= 0  ){
			return;
		}
		
		Iterator itr = eeServiceRequest.iterator();
		while( itr.hasNext()) {
			EEServiceUserRequest request = (EEServiceUserRequest)itr.next();
			removeRequest(request);
		}
		
	}
	public void addRequest(EEServiceRequest eeServiceRequest) {
		if (this.eeServiceUserRequests == null)
			this.eeServiceUserRequests = new HashSet();
		
		this.eeServiceUserRequests.add(eeServiceRequest);
		//eeServiceRequest.se.setEeServiceUser(this);
	}
	protected void buildToString(ToStringBuilder builder) {
		builder.append("userName", this.userName);
		builder.append("password", this.password);
		builder.append("contactName", this.contactName);
		builder.append("contactPhone", this.contactPhone);
		builder.append("activeFlag", this.active);
		builder.append("eeServiceUserRequests", eeServiceUserRequests);
	}
}
