package gov.va.med.esr.common.model.security;

import gov.va.med.esr.common.model.lookup.EEServiceField;
import gov.va.med.esr.common.model.lookup.EEServiceFieldLite;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

public class EEServiceRequestField extends AbstractKeyedEntity {
	         
	private static final long serialVersionUID = 565017800777780194L;
	private EEServiceFieldLite eeServiceField;
	private EEServiceRequest eeServiceRequest;

	public EEServiceRequest getEeServiceRequest() {
		return eeServiceRequest;
	}

	public void setEeServiceRequest(EEServiceRequest eeServiceRequest) {
		this.eeServiceRequest = eeServiceRequest;
	}

	public EEServiceFieldLite getEeServiceField() {
		return eeServiceField;
	}

	public void setEeServiceField(EEServiceFieldLite eeServiceField) {
		this.eeServiceField = eeServiceField;
	}
	
    public void setIdentifier(Serializable identifier) {
        super.setIdentifier(identifier);
    }

    public Serializable getIdentifier() {
    	return super.getIdentifier();
    }
    
	protected void buildToString(ToStringBuilder builder) {
		builder.append("eeServiceField", this.eeServiceField);
	}
	
	
	public boolean equals(Object o) {
	   if ( o != null  && o instanceof EEServiceRequestField) {
		   EEServiceRequestField eeRequestField = (EEServiceRequestField)o;
		  boolean equalsTest =eeServiceField.equals(eeRequestField.getEeServiceField()); 
		   return equalsTest;
	   }
	   return false;
	}
	
	public int hashCode() {
		if ( eeServiceField != null)
		return eeServiceField.getIdentifier().hashCode();
		
		return 0;
	}
	
  }
