package gov.va.med.esr.common.model.security;

import gov.va.med.fw.model.AbstractKeyedEntity;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.builder.ToStringBuilder;

public class EEServiceRequest extends AbstractKeyedEntity {


	private static final long serialVersionUID = 237801646502407311L;
	private String name;
	private String description;
	
	private Set eeServiceGroups;
	private Set eeServiceFields;
		
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Set getEeServiceGroups() {
		return eeServiceGroups;
	}

	public void setEeServiceGroups(Set eeServiceGroups) {
		this.eeServiceGroups = eeServiceGroups;
	}

	public Set getEeServiceFields() {
		return eeServiceFields;
	}

	public void setEeServiceFields(Set eeServieFields) {
		this.eeServiceFields = eeServieFields;

	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

/*	public void addFields(Set fields) {
		if (this.eeServiceFields == null)
			this.eeServiceFields = new HashSet();
		this.eeServiceFields.addAll(fields);
	}*/

	public void addField(EEServiceRequestField eeServiceRequestField) {
		if (this.eeServiceFields == null)
			this.eeServiceFields = new HashSet();
		
		this.eeServiceFields.add(eeServiceRequestField);
		eeServiceRequestField.setEeServiceRequest(this);
	}

	
	public void removeField(EEServiceRequestField eeServiceRequestField ) {
		boolean test = this.eeServiceFields.remove(eeServiceRequestField);
		System.out.println("removing field:" + eeServiceRequestField.getEeServiceField().getCode() + "test:" + test);
	}
	
	public void removeFields(Set eeServiceRequestFields ) {
		if (eeServiceRequestFields != null && eeServiceRequestFields.size() <= 0  ){
			return;
		}
		
		Iterator itr = eeServiceRequestFields.iterator();
		while( itr.hasNext()) {
			EEServiceRequestField field = (EEServiceRequestField)itr.next();
			removeField(field);
		}
		
	}
	
	/**
	 * returns a Set containing the list of fieldNames as Strings
	 * @return
	 */
	public Set getFieldsSet() {
		
		HashSet fieldSet = new HashSet();
		if (this.eeServiceFields == null  || this.eeServiceFields.size() <= 0 ) {
			return fieldSet;
		}
		Iterator itr = getEeServiceFields().iterator();
		while( itr.hasNext()) {
			EEServiceRequestField field = (EEServiceRequestField)itr.next();
			fieldSet.add(field.getEeServiceField().getCode());
		}
		return fieldSet;
	}
	
    public void setIdentifier(Serializable identifier) {
        super.setIdentifier(identifier);
    }

    public Serializable getIdentifier() {
        return super.getIdentifier();
    }

    
	protected void buildToString(ToStringBuilder builder) {
		builder.append("name", this.name);
		builder.append("description", this.description);
		builder.append("eeServiceGroups", this.eeServiceGroups);
		builder.append("eeServiceFields", this.eeServiceFields);
	}

}
