/*****************************************************************************************
 * Copyright  2004 VHA. All rights reserved
 ****************************************************************************************/
package gov.va.med.esr.common.model.security;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

import gov.va.med.esr.common.model.lookup.Capability;

public class CapabilitySetCapability extends AbstractKeyedEntity {

   /**
    * An instance of serialVersionUID
    */
   private static final long serialVersionUID = 1184393298552399900L;

   private Capability capability;

   private CapabilitySet capabilitySet;

   public CapabilitySetCapability() {
      super();
   }

   public CapabilitySetCapability(CapabilitySet capabilitySet, Capability capability) {
      Validate.notNull(capabilitySet,
            "CapabilitySet can not be null in CapabilitySetCapability");
      Validate.notNull(capability,
            "Capability can not be null in CapabilitySetCapability");
      this.capability = capability;
      this.capabilitySet = capabilitySet;
   }

   public Capability getCapability() {
      return capability;
   }

   public CapabilitySet getCapabilitySet() {
      return capabilitySet;
   }

   private void setCapability(Capability capability) {
      this.capability = capability;
   }

   private void setCapabilitySet(CapabilitySet capabilitySet) {
      this.capabilitySet = capabilitySet;
   }

   protected void buildToString(ToStringBuilder builder) {
      super.buildToString(builder);
      builder.append("capability", this.capability);
   }
   
   protected void finalize() throws Throwable {
      super.finalize();
      setCapability( null );
      setCapabilitySet( null );
   }
}
