/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.security;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;

import gov.va.med.esr.common.model.lookup.Capability;

public class AbstractPermission extends AbstractKeyedEntity implements Comparable{
    
    private static final long serialVersionUID = -5541905456916221664L;
    
    private String name;
    private String description;
    private Date activeDate;
    private Date inactiveDate;
    private Boolean assigned;
    
    public Date getActiveDate() {
        return activeDate;
    }
    public void setActiveDate(Date activeDate) {
        this.activeDate = activeDate;
    }
    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    public Date getInactiveDate() {
        return inactiveDate;
    }
    public void setInactiveDate(Date inactiveDate) {
        this.inactiveDate = inactiveDate;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
        
    public Boolean getAssigned() {
        return assigned;
    }
    
    public Boolean isAssigned() {
        return getAssigned() == null ? Boolean.FALSE : getAssigned();
    }    

    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    public boolean isActive() {
        return isActive(activeDate,inactiveDate);
    }
    
    public boolean isAssignable() {
        return isAssignable(activeDate,inactiveDate);
    }
    
    public int compareTo(Object o) {
        if (o != null && o instanceof AbstractPermission)
            return getName().compareTo(((AbstractPermission)o).getName());
        else
            return 1;
    }    
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("name", this.name);
        builder.append("description", this.description);
        builder.append("activeDate", this.activeDate);
        builder.append("inactiveDate", this.inactiveDate);
        builder.append("assigned", this.assigned);
    }
    
    
    public static boolean isActive(Date starteDate, Date endDate) {
        Date today = DateUtils.getCurrentDate();
        if ((starteDate != null && starteDate.after(today)) ||
            (endDate != null && !endDate.after(today)))
        {
            return false;
        }
        else {
            return true;
        }
    }
    /**
     * Permission is assignable if it is not inactive 
     * @param starteDate
     * @param endDate
     * @return
     */
    public static boolean isAssignable(Date starteDate, Date endDate) {
        Date today = DateUtils.getCurrentDate();
        if (endDate == null || endDate.after(today))
        {
            return true;
        }
        else {
            return false;
        }
    }
}
