/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Apr 13, 2006
 *
 */
package gov.va.med.esr.common.model.report;

import java.util.Date;

import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.report.data.ReportConstants;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.StringUtils;

// Java classes

// Library classes

// Framework classes

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class SimpleCompletedReport extends AbstractKeyedEntity {

	
	private static final long serialVersionUID = -5508330144320486812L;
	public static final String NEW_LINE="\n";
	public static final String HTML_BR="<br>";
    
    

	public SimpleCompletedReport() {
		super();
	}

    public StandardReport getStandardReport() {
    	return this.standardReport;
    }
    
    public void setStandardReport(StandardReport standardReport) {
    	this.standardReport = standardReport;
    }
    
    public ReportExportedType getFileType() {
    	return this.fileType;
    }
    
    public void setFileType(ReportExportedType fileType) {
    	this.fileType = fileType;
    }
    
    public Date getCompletedDate() {
    	return this.completedDate;
    }
    
    public void setCompletedDate(Date completedDate) {
    	this.completedDate = completedDate;
    }
    
    public ESRUserPrincipal getUser() {
    	return this.user;
    }
    
    public void setUser(ESRUserPrincipal user) {
    	this.user = user;
    }
 
    public String getReportParameterText() {
		return reportParameterText;
	}
    
    public String getHTMLFormattedReportParameterText() {
    	return reportParameterText!=null?StringUtils.replace(reportParameterText, NEW_LINE, HTML_BR):null;		
	}
	
	public void setReportParameterText(String reportParameterText) {
		this.reportParameterText = reportParameterText;
	}    
    
    public Date getInactivatedDate() {
        return inactivatedDate;
    }

    public void setInactivatedDate(Date archivedDate) {
        this.inactivatedDate = archivedDate;
    }   
    public String getStatus()  {
       return inactivatedDate!=null ? ReportConstants.ARCHIVED : ReportConstants.ACTIVE;
    }
    // The StandardReport type this complete report belongs to
    private StandardReport standardReport;
    
    private Date completedDate;
    
    private ReportExportedType fileType;
        
    // The user who setup the report 
    private ESRUserPrincipal user; 
    
    private String reportParameterText;
    
    private Date inactivatedDate;      
    
}

