/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.AACIndicator;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportVBAQueryStatus extends BaseReportLookupParameter {
	private static final long serialVersionUID = -5456140444858958840L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof AACIndicator,"Incorrect lookup type.");
		super.setLookup(lookup);
	}


	public AACIndicator getVBAQueryStatus() {
		return (AACIndicator)getLookup();
	}
	
	public void setVBAQueryStatus(AACIndicator vBAQueryStatus) {
		setLookup(vBAQueryStatus);
	}	
}

