/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 27, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// EDB Classes
import gov.va.med.esr.common.model.security.ESRUserPrincipal;

/**
 * @author Yi He
 * @version 1.0
 * This class capture the users as part of the USER report parameter.
 */
public class ReportUser extends AbstractKeyedEntity implements ReportParameter {
	private static final long serialVersionUID = 7310530800150827801L;
	
	public ReportSetup getReportSetup() {
		return this.reportSetup;
	}
	
	public void setReportSetup(ReportSetup reportSetup) {
        validateOwner(this.reportSetup, reportSetup);
		this.reportSetup = reportSetup;
	}
	
	public ESRUserPrincipal getUser() {
		return this.user;
	}
	
	public void setUser(ESRUserPrincipal user) {
		this.user = user;
	}
	
	private ReportSetup reportSetup; // The parent object containing the report the list of report params.
	private ESRUserPrincipal user;
}

