/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
// Package
package gov.va.med.esr.common.model.report;

// Java classes
import java.util.Date;

// Library classes

import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;

// ESR classes;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;

/**
 * 
 *
 * Project: Common</br>
 * Created on: 10:53:13 AM </br>
 *
 * @author DNS   LEV
 */
public class ReportSetup extends AbstractKeyedEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6397749234410088086L;

	/**
	 * A default constructor
	 */
	public ReportSetup() {
		super();
	}

	/**
	 * A default constructor
	 * @param identifier
	 */
	public ReportSetup(EntityKey identifier) {
		super(identifier);
	}

	/**
	 * A default constructor
	 * @param identifier
	 * @param createdOn
	 * @param modifiedOn
	 * @param version
	 */
	public ReportSetup(EntityKey identifier, Date createdOn,
			Date modifiedOn, Integer version) {
		super(identifier, createdOn, modifiedOn, version);
	}
	
	
	public StandardReport getReport() {
		return this.report;
	}
	
	public void setReport(StandardReport report) {
		this.report = report;
	}
	
	public ESRUserPrincipal getSetupUser() {
		return this.setupUser;
	}
	
	public void setSetupUser(ESRUserPrincipal setupUser) {
		this.setupUser = setupUser;
	}	

    public String getEmail() {
    	return this.email;
    }
    
    public void setEmail(String email) {
    	this.email = email;
    }
    
    public ReportParameterSet getParameterSet() {
    	return this.parameterSet;
    }
    
    public void setParameterSet(ReportParameterSet parameterSet) {
    	this.parameterSet = parameterSet;
    	if(this.parameterSet!=null)
    		this.parameterSet.setReportSetup(this);
    }
    
    public ReportSchedule getSchedule() {
    	return this.schedule;
    }
    
    public void setSchedule(ReportSchedule schedule) {
    	this.schedule = schedule;
    	if(this.schedule!=null)    		
    		this.schedule.setReportSetup(this);
    }    
		
	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString( ToStringBuilder builder ) {
		super.buildToString(builder);
	}

	/**
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
	}
	
	private StandardReport report;  // the standard report that this report belongs
	
	private ESRUserPrincipal setupUser; // The user who configured or scheduled the report  	

	private String email;  // list of email for report recepients
	
	private ReportParameterSet parameterSet; // the set of parameters for the report
	
	private ReportSchedule schedule; // the scheduling information of the report
	
}