/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;

// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.RegistryType;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportRegistryType extends BaseReportLookupParameter {
	private static final long serialVersionUID = -8550348568390446748L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof RegistryType,"Incorrect lookup type.");
		super.setLookup(lookup);
	}

	public RegistryType getRegistryType() {
		return (RegistryType)getLookup();
	}
	
	public void setRegistryType(RegistryType registryType) {
		setLookup(registryType);
	}
}

