/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportQueryToSite extends BaseReportLookupParameter {
	private static final long serialVersionUID = 4098182537541456205L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof VAFacility,"Incorrect lookup type.");
		super.setLookup(lookup);
	}


	public VAFacility getQueryToSite() {
		return (VAFacility)getLookup();
	}
	
	public void setQueryToSite(VAFacility queryToSite) {
		setLookup(queryToSite);
	}

}

