/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.RejectionRemark;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportPHRejectionRemark extends BaseReportLookupParameter {
	private static final long serialVersionUID = -1915107928594661490L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof RejectionRemark,"Incorrect lookup type.");
		super.setLookup(lookup);
	}

	public RejectionRemark getRejectionRemark() {
		return (RejectionRemark)getLookup();
	}
	
	public void setRejectionRemark(RejectionRemark rejectionRemark) {
		setLookup(rejectionRemark);
	}
}

