/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 2, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;


//EDB Classes
import gov.va.med.esr.common.model.lookup.MessageType;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportMessageType extends BaseReportLookupParameter {
	private static final long serialVersionUID = -7199636556367595757L;
	
    public void setLookup(Lookup lookup) {
	    Validate.isTrue(lookup instanceof MessageType,"Incorrect lookup type.");
	    super.setLookup(lookup);
    }


	public MessageType getMessageType() {
		return (MessageType) getLookup();
	}
	
	public void setMessageType(MessageType messageType) {
		setLookup(messageType);
	}
}

