/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.AckType;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportMessageError extends BaseReportLookupParameter {
	private static final long serialVersionUID = -4498173119319896830L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof AckType,"Incorrect lookup type.");
		super.setLookup(lookup);
	}


	public AckType getMessageError() {
		return (AckType)getLookup();
	}
	
	public void setMessageError(AckType messageError) {
		setLookup(messageError);
	}

}

