/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;


// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.FunctionalGroup;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportFunctionalGroup extends BaseReportLookupParameter {
	private static final long serialVersionUID = -6935388824698070279L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof FunctionalGroup,"Incorrect lookup type.");
		super.setLookup(lookup);
	}
	public FunctionalGroup getFunctionalGroup() {
		return (FunctionalGroup)getLookup();
	}
	
	public void setFunctionalGroup(FunctionalGroup functionalGroup) {
		setLookup(functionalGroup);
	}
}

