/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 2, 2006
 *
 */
package gov.va.med.esr.common.model.report;




// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.VOAFormType;

/**
 * @author Amy Jones
 * @version 1.0
 */
public class ReportFormType extends BaseReportLookupParameter {
	private static final long serialVersionUID = 1L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof VOAFormType,"Incorrect lookup type.");
		super.setLookup(lookup);
	}
	public VOAFormType getVOAFormType() {
		return (VOAFormType) getLookup();
	}
	
	public void setVOAFormType(VOAFormType voaFormType) {
		setLookup(voaFormType);
	}
}

