/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.VAFacility;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportFacility extends BaseReportLookupParameter {
	private static final long serialVersionUID = 1384350918367107728L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof VAFacility,"Incorrect lookup type.");
		super.setLookup(lookup);
	}

	public VAFacility getFacility() {
		return (VAFacility)getLookup();
	}
	
	public void setFacility(VAFacility facility) {
		setLookup(facility);
	}
}

