/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Apr 28, 2006
 *
 */
package gov.va.med.esr.common.model.report;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.Lookup;

import org.apache.commons.lang.Validate;

// Framework classes

// EDB Classes
import gov.va.med.esr.common.model.lookup.EnrollmentStatusComponent;

/**
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class ReportEnrollmentStatusComponent extends BaseReportLookupParameter {

	private static final long serialVersionUID = -930926104740173937L;
	
	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof EnrollmentStatusComponent,"Incorrect lookup type.");
		super.setLookup(lookup);
	}
	
	public EnrollmentStatusComponent getEnrollmentStatusComponent() {
		return (EnrollmentStatusComponent)getLookup();
	}
	
	public void setEnrollmentStatusComponent(EnrollmentStatusComponent enrollmentStatusComponent) {
		setLookup(enrollmentStatusComponent);
	}

}

