/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportEnrollmentStatus extends BaseReportLookupParameter {
	private static final long serialVersionUID = -8915841692977397229L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof EnrollmentStatus,"Incorrect lookup type.");
		super.setLookup(lookup);
	}
	public EnrollmentStatus getEnrollmentStatus() {
		return (EnrollmentStatus)getLookup();
	}
	
	public void setEnrollmentStatus(EnrollmentStatus enrollmentStatus) {
		setLookup(enrollmentStatus);
	}
}

