/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes

// Framework classes
import org.apache.commons.lang.builder.HashCodeBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

// EDB Classes
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportEnrollmentPriorityGroup extends AbstractKeyedEntity implements
		ReportParameter {
	private static final long serialVersionUID = -5046128496158107408L;

	public ReportSetup getReportSetup() {
		return this.reportSetup;
	}
	
	public void setReportSetup(ReportSetup reportSetup) {
        validateOwner(this.reportSetup, reportSetup);
		this.reportSetup = reportSetup;
	}

	public EnrollmentPriorityGroup getEnrollmentPriorityGroup() {
		return this.enrollmentPriorityGroup;
	}
	
	public void setEnrollmentPriorityGroup(EnrollmentPriorityGroup enrollmentPriorityGroup) {
		this.enrollmentPriorityGroup = enrollmentPriorityGroup;
	}

	public EnrollmentPrioritySubGroup getEnrollmentPrioritySubGroup() {
		return this.enrollmentPrioritySubGroup;
	}
	
	public void setEnrollmentPrioritySubGroup(EnrollmentPrioritySubGroup enrollmentPrioritySubGroup) {
		this.enrollmentPrioritySubGroup = enrollmentPrioritySubGroup;
	}
    
	private ReportSetup reportSetup; // The parent object containing the report the list of report params.
    private EnrollmentPriorityGroup enrollmentPriorityGroup; 
    private EnrollmentPrioritySubGroup enrollmentPrioritySubGroup; 
}

