/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Apr 28, 2006
 *
 */
package gov.va.med.esr.common.model.report;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.Lookup;

import org.apache.commons.lang.Validate;

// Framework classes

// EDB Classes
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportEnrollmentCategory extends BaseReportLookupParameter {

	private static final long serialVersionUID = -930926104740173937L;
	
	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof EnrollmentCategory,"Incorrect lookup type.");
		super.setLookup(lookup);
	}
	
	public EnrollmentCategory getEnrollmentCategory() {
		return (EnrollmentCategory)getLookup();
	}
	
	public void setEnrollmentCategory(EnrollmentCategory EnrollmentCategory) {
		setLookup(EnrollmentCategory);
	}

}

