/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;



// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.ReportEEDWeeklyType;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportEEDWeeklyReportType extends BaseReportLookupParameter {
	private static final long serialVersionUID = 3185086710380072848L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof ReportEEDWeeklyType,"Incorrect lookup type.");
		super.setLookup(lookup);
	}

	public ReportEEDWeeklyType getReportEEDWeeklyType() {
		return (ReportEEDWeeklyType)getLookup();
	}
	
	public void setReportEEDWeeklyType(ReportEEDWeeklyType eedWeeklyType) {
		setLookup(eedWeeklyType);
	}
}

