/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 3, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.DayOfWeek;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportDayOfWeek extends BaseReportLookupParameter {
	private static final long serialVersionUID = -4534759664565208567L;

	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof DayOfWeek,"Incorrect lookup type.");
		super.setLookup(lookup);
	}
	
	public DayOfWeek getDayOfWeek() {
		return (DayOfWeek)getLookup();
	}
	
	public void setDayOfWeek(DayOfWeek dayOfWeek) {
		setLookup(dayOfWeek);
	}
}

