/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 2, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes
import org.apache.commons.lang.Validate;

// Framework classes
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes
import gov.va.med.esr.common.model.lookup.BadAddressReason;

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportBadAddressReason extends BaseReportLookupParameter {

	private static final long serialVersionUID = 6474161541497713329L;
	
	public void setLookup(Lookup lookup) {
		Validate.isTrue(lookup instanceof BadAddressReason,"Incorrect lookup type.");
		super.setLookup(lookup);
	}
	
	public BadAddressReason getBadAddressReason() {
		return (BadAddressReason) getLookup();
	}
	
	public void setBadAddressReason(BadAddressReason badAddressReason) {
		setLookup(badAddressReason);
	}	
	

}

