/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 6, 2006
 *
 */
package gov.va.med.esr.common.model.report;


// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.lookup.Lookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public abstract class BaseReportLookupParameter extends AbstractKeyedEntity implements
		ReportLookupParameter {

	
    private static final long serialVersionUID = -1370346746640850300L;
    public Lookup getLookup() {
        return lookup;
	}

	public void setLookup(Lookup lookup) {
		this.lookup = lookup;
	}

	public ReportSetup getReportSetup() {
		return this.reportSetup;
	}
	
	public void setReportSetup(ReportSetup reportSetup) {
        validateOwner(this.reportSetup, reportSetup);
		this.reportSetup = reportSetup;
	}

	
	private ReportSetup reportSetup; // The parent object containing the report the list of report params.
    private Lookup lookup; // The lookup object that represents the value of this parameter
}

