/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.registry;

// Java classes
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistryTraitDetail extends AbstractKeyedEntity {

    private static final long serialVersionUID = -5938910697096303042L;

    private RegistryTrait registryTrait             = null;

    // Military Service Number of the veteran
    private String militaryServiceNumber            = null;

    /**
     * Creates a new Registry object.
     */
    public RegistryTraitDetail() {
        super();
    }

    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------
    public RegistryTrait getRegistryTrait() {
        return registryTrait;
    }

    public void setRegistryTrait(RegistryTrait registryTrait) {
        this.registryTrait = registryTrait;
    }

    public String getMilitaryServiceNumber() {
        return militaryServiceNumber;
    }

    public void setMilitaryServiceNumber(String militaryServiceNumber) {
        this.militaryServiceNumber = militaryServiceNumber;
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("registryTrait", this.registryTrait);
        builder.append("militaryServiceNumber", this.militaryServiceNumber);
    }
}