package gov.va.med.esr.common.model.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.util.StringUtils;
/**
 * Data in the Registry Summary table populated during the load registry process.
 *  
 * @author Rajiv Patnaik
 * Created on Apr 21, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class RegistryLoadStatistics extends AbstractKeyedEntity
{ 
	private static final long serialVersionUID = -4078984709658419472L;

	private RegistryType registryType;
    private int recordsRead;
    private int recordsPassedConsistencyCheck;
    private int recordsFailedConsistencyCheck;
    private int recordsNotMatchedToExistingRecords;
    private int recordsMatchedToExistingRecords;
    private int recordsAmbiguouslyMatched;
    private int newRegistryEntriesInserted;  
    private Set internalRegistryLoadExceptions;
    
    /**
     * @return Returns the newRegistryEntriesInserted.
     */
    public int getNewRegistryEntriesInserted()
    {
        return newRegistryEntriesInserted;
    }
    /**
     * @param newRegistryEntriesInserted The newRegistryEntriesInserted to set.
     */
    public void setNewRegistryEntriesInserted(int newRegistryEntriesInserted)
    {
        this.newRegistryEntriesInserted = newRegistryEntriesInserted;
    }
    /**
     * @return Returns the recordsAmbiguouslyMatched.
     */
    public int getRecordsAmbiguouslyMatched()
    {
        return recordsAmbiguouslyMatched;
    }
    /**
     * @param recordsAmbiguouslyMatched The recordsAmbiguouslyMatched to set.
     */
    public void setRecordsAmbiguouslyMatched(int recordsAmbiguouslyMatched)
    {
        this.recordsAmbiguouslyMatched = recordsAmbiguouslyMatched;
    }
    /**
     * @return Returns the recordsMatchedToExistingRecords.
     */
    public int getRecordsMatchedToExistingRecords()
    {
        return recordsMatchedToExistingRecords;
    }
    /**
     * @param recordsMatchedToExistingRecords The recordsMatchedToExistingRecords to set.
     */
    public void setRecordsMatchedToExistingRecords(
            int recordsMatchedToExistingRecords)
    {
        this.recordsMatchedToExistingRecords = recordsMatchedToExistingRecords;
    }
    /**
     * @return Returns the recordsNotMatchedToExistingRecords.
     */
    public int getRecordsNotMatchedToExistingRecords()
    {
        return recordsNotMatchedToExistingRecords;
    }
    /**
     * @param recordsNotMatchedToExistingRecords The recordsNotMatchedToExistingRecords to set.
     */
    public void setRecordsNotMatchedToExistingRecords(
            int recordsNotMatchedToExistingRecords)
    {
        this.recordsNotMatchedToExistingRecords = recordsNotMatchedToExistingRecords;
    }

    /**
     * @return Returns the recordsFailedConsistencyCheck.
     */
    public int getRecordsFailedConsistencyCheck()
    {
        return recordsFailedConsistencyCheck;
    }
    /**
     * @param recordsFailedConsistencyCheck The recordsFailedConsistencyCheck to set.
     */
    public void setRecordsFailedConsistencyCheck(
            int recordsFailedConsistencyCheck)
    {
        this.recordsFailedConsistencyCheck = recordsFailedConsistencyCheck;
    }
    /**
     * @return Returns the recordsPassedConsistenceyCheck.
     */
    public int getRecordsPassedConsistencyCheck()
    {
        return recordsPassedConsistencyCheck;
    }
    /**
     * @param recordsPassedConsistenceyCheck The recordsPassedConsistenceyCheck to set.
     */
    public void setRecordsPassedConsistencyCheck(
            int recordsPassedConsistencyCheck)
    {
        this.recordsPassedConsistencyCheck = recordsPassedConsistencyCheck;
    }
    /**
     * @return Returns the recordsRead.
     */
    public int getRecordsRead()
    {
        return recordsRead;
    }
    /**
     * @param recordsRead The recordsRead to set.
     */
    public void setRecordsRead(int recordsRead)
    {
        this.recordsRead = recordsRead;
    }

    /**
     * @return Returns the registryType.
     */
    public RegistryType getRegistryType()
    {
        return registryType;
    }
    /**
     * @param registryType The registryType to set.
     */
    public void setRegistryType(RegistryType registryType)
    {
        this.registryType = registryType;
    }
    
    /**
     * Getter - for hibernate use only.
     * 
     * @return
     */
    private Set getInternalRegistryLoadExceptions() {
       if( this.internalRegistryLoadExceptions == null ) {
          this.internalRegistryLoadExceptions = new HashSet();
       }
       return this.internalRegistryLoadExceptions;
    }    
    /**
     * @return Returns the internalRegistryLoadExceptions.
     */
    public Set getRegistryLoadExceptions()
    {
        return Collections.unmodifiableSet(getInternalRegistryLoadExceptions());
    }
    /**
     * Setter - for hibernate use only.     * @param internalRegistryLoadExceptions The internalRegistryLoadExceptions to set.
     */
    public void setInternalRegistryLoadExceptions(
            Set internalRegistryLoadExceptions)
    {
        this.internalRegistryLoadExceptions = internalRegistryLoadExceptions;
    }
    
    /**
     * Add a RegistryLoadException. This method takes care of Bidirectional setting of
     * RegistryLoadException's  RegistryLoadStatistics.
     * 
     * @param registryLoadExceptionDetail
     */
    public void addRegistryLoadException(RegistryLoadException registryLoadException) {
       Validate.notNull(registryLoadException, "Null registryLoadExceptionDetail specified.");
       registryLoadException.setRegistryLoadStatistics(this);
       getInternalRegistryLoadExceptions().add(registryLoadException);
    }

    /**
     * Add a collection of RegistryLoadExceptionDetails . This method takes care of Bidirectional
     * setting of RegistryLoadException's RegistryLoadStatistics.
     * 
     * @param phones
     */
    public void addAllRegistryLoadExceptionDetails(
            Set registryLoadExceptions)
    {
        Validate.notNull(registryLoadExceptions,
                "Null set of registryLoadExceptionDetails specified.");
        if (registryLoadExceptions != null)
        {
            for (Iterator i = registryLoadExceptions.iterator(); i
                    .hasNext();)
            {
                RegistryLoadException registryLoadException = 
                    (RegistryLoadException)i.next();
                this.addRegistryLoadException(registryLoadException);
            }
        }
    }    
    
    /**
     * @param identifier
     * @return RegistryLoadException
     */
    public RegistryLoadException getRegistryLoadExceptionByEntityKey(EntityKey identifier) {
        return (RegistryLoadException) getEntityByEntityKey(getRegistryLoadExceptions(), identifier);
    } 
    
	protected void buildToString(ToStringBuilder builder) {
		builder.append("registryType", registryType != null ? registryType.getDescription():StringUtils.EMPTY);  
		builder.append("recordsRead", recordsRead);
		builder.append("recordsPassedConsistencyCheck", recordsPassedConsistencyCheck);
		builder.append("recordsFailedConsistencyCheck", recordsFailedConsistencyCheck);
		builder.append("recordsNotMatchedToExistingRecords", recordsNotMatchedToExistingRecords);
		builder.append("recordsMatchedToExistingRecords", recordsMatchedToExistingRecords);
		builder.append("recordsAmbiguouslyMatched", recordsAmbiguouslyMatched);
		builder.append("newRegistryEntriesInserted", newRegistryEntriesInserted);
	}    

}
