package gov.va.med.esr.common.model.registry;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.fw.model.AbstractKeyedEntity;
/**
 * Stores the exception details during the Load Registry Process
 * 
 * @author Rajiv Patnaik
 * Created on Oct 12, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class RegistryLoadException extends AbstractKeyedEntity
{ 
	private static final long serialVersionUID = 2872854417618705156L;

	private RegistryLoadStatistics registryLoadStatistics;
    private ReportExceptionType reportExceptionType;
    private String exceptionRecordText;
    
    /**
     * @return Returns the exceptionRecordText.
     */
    public String getExceptionRecordText()
    {
        return exceptionRecordText;
    }
    /**
     * @param exceptionRecordText The exceptionRecordText to set.
     */
    public void setExceptionRecordText(String exceptionText)
    {
        this.exceptionRecordText = exceptionText;
    }
    /**
     * @return Returns the registryLoadStatistics.
     */
    public RegistryLoadStatistics getRegistryLoadStatistics()
    {
        return registryLoadStatistics;
    }
    /**
     * @param registryLoadStatistics The registryLoadStatistics to set.
     */
    public void setRegistryLoadStatistics(
            RegistryLoadStatistics registryLoadStatistics)
    {
        validateOwner(this.registryLoadStatistics, registryLoadStatistics);
        this.registryLoadStatistics = registryLoadStatistics;
    }
    /**
     * @return Returns the reportExceptionType.
     */
    public ReportExceptionType getReportExceptionType()
    {
        return reportExceptionType;
    }
    /**
     * @param reportExceptionType The reportExceptionType to set.
     */
    public void setReportExceptionType(ReportExceptionType reportExceptionType)
    {
        this.reportExceptionType = reportExceptionType;
    } 
    
	protected void buildToString(ToStringBuilder builder) {
		builder.append("reportExceptionType", reportExceptionType);
		builder.append("exceptionRecordText", exceptionRecordText);
	}       
}
