/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.registry;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 
 * @author Muddaiah Ranga
 * @version 1.0
 */
public abstract class Registry extends AbstractKeyedEntity {
    
    
    private static final long serialVersionUID = -1370346746640850300L;
    private Person          person;
    private RegistryTrait   registryTrait;
 
    public Registry() {
        super();
    }
    
    //----------------------------------------------------------------------------
    // Public method(s)
    //----------------------------------------------------------------------------

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person,person);
        this.person = person;
    }
    
    public RegistryTrait getRegistryTrait() {
        return this.registryTrait;
    }
    
    public void setRegistryTrait(RegistryTrait registryTrait) {
        this.validateOwner(this.registryTrait,registryTrait);
        this.registryTrait = registryTrait;
    }
    
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder
            .append("registryTrait",this.registryTrait)
        );
    }
}
