/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.model.person.id;

import org.apache.commons.lang.StringUtils;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.BaseEntityKey;
import gov.va.med.person.idmgmt.VPID;

/**
 * Initial javadoc for class VPIDEntityKeyImpl. TODO - Add content here
 * 
 * Created Jul 19, 2005 11:19:25 PM
 * 
 * @author DNS   BOHMEG
 */
public class VPIDEntityKeyImpl extends BaseEntityKey implements VPIDEntityKey {
	/**
	 * 
	 */
	private static final long serialVersionUID = 4778695255995973360L;

	public VPIDEntityKeyImpl(String VPID) {
		super(VPID, Person.class);
	}

	/** Do not call this method.  It is for use by XML Serialization only. */
	public VPIDEntityKeyImpl() {
		super();
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.esr.common.model.person.id.VPIDEntityKey#getVPID()
	 */
	public String getVPID() {
		return (String) this.getKeyValue();
	}

	/** Do not call this method.  It is for use by XML Serialization only. */
	public void setVpid(String vpid) {
		setKeyValue(vpid, VPIDEntityKeyImpl.class);
	}
	
	public String getShortVPID() {
		return getShortVPID(getVPID());
	}

	public static String getShortVPID(String vpidValue) {
		return VPID.getShortVPID(vpidValue);
	}

	public String getLongVPID() {
		return getLongVPID(getVPID());
	}

	public static String getLongVPID(String vpidValue) {
		if (StringUtils.isBlank(vpidValue))
			return vpidValue;

		try {
			VPID longVpid = new VPID(vpidValue);
			return longVpid.getVPID().getIdentifier();
		} catch (Exception ve) {
			IllegalArgumentException e = new IllegalArgumentException(
					"Unable to get the long form VPID from: " + vpidValue);
			e.initCause(ve);
			throw e;
		}
	}
}
