package gov.va.med.esr.common.model.person;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.esr.common.model.lookup.AuthenticationLevel;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VOAApplicationStatus;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.VOAFormType;
import gov.va.med.esr.common.model.lookup.VeteranIdentifierType;
import gov.va.med.fw.model.AbstractKeyedEntity;

public class VOAApplication extends AbstractKeyedEntity {

	private static final long serialVersionUID = 7947904918962959457L;

	private BigDecimal applicationId = null;
	
	private BigDecimal personId = null;

	private String lastName = null;

	private String firstName = null;

	private String middleName = null;

	private Date dateOfBirth = null;

	private String ssn = null;

	private Date responseTimeStamp = null;

	private String errorText = null;

	private String fullQualifiedId = null;

	private Date receiveTimeStamp = null;

	private VAFacility preferredFacility = null;

	private VOAFormType formType = null;

	private VOAApplicationStatus applicationStatus = null;

	private Gender gender = null;

	private AuthenticationLevel authenticationLevel = null;

	private VeteranIdentifierType identityType = null;

	private Set internalFileAttachments = null;

	private Set internalVOAApplicationData = null;
	
	private Set internalVOAResubmissionApps = null;


	private int hashValue = 0;

	public VOAApplication() {
		super();
	}
	


	   public VOAApplicationStatus getApplicationStatus() {
		return applicationStatus;
	}



	public void setApplicationStatus(VOAApplicationStatus applicationStatus) {
		this.applicationStatus = applicationStatus;
	}



	public AuthenticationLevel getAuthenticationLevel() {
		return authenticationLevel;
	}



	public void setAuthenticationLevel(AuthenticationLevel authenticationLevel) {
		this.authenticationLevel = authenticationLevel;
	}



	public Date getDateOfBirth() {
		return dateOfBirth;
	}



	public void setDateOfBirth(Date dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}



	public String getErrorText() {
		return errorText;
	}



	public void setErrorText(String errorText) {
		this.errorText = errorText;
	}



	public String getFirstName() {
		return firstName;
	}



	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}



	public VOAFormType getFormType() {
		return formType;
	}



	public void setFormType(VOAFormType formType) {
		this.formType = formType;
	}



	public String getFullQualifiedId() {
		return fullQualifiedId;
	}



	public void setFullQualifiedId(String fullQualifiedId) {
		this.fullQualifiedId = fullQualifiedId;
	}



	public Gender getGender() {
		return gender;
	}



	public void setGender(Gender gender) {
		this.gender = gender;
	}

	public BigDecimal getApplicationId() {
		return applicationId;
	}


	public void setApplicationId(BigDecimal applicationId) {
		this.applicationId = applicationId;
	}

	public VeteranIdentifierType getIdentityType() {
		return identityType;
	}

	public void setIdentityType(VeteranIdentifierType identityType) {
		this.identityType = identityType;
	}

	private Set getInternalFileAttachments() {
	      if( internalFileAttachments == null ) {
		         this.internalFileAttachments = new HashSet();
		      }
		      return this.internalFileAttachments;
		   }

	private void setInternalFileAttachments(Set internalFileAttachments) {
		this.internalFileAttachments = internalFileAttachments;
	}

   /**
    * Unmodifiable
    * 
    * @return
    */
   public Set getFileAttachments() {
      return Collections.unmodifiableSet(getInternalFileAttachments());
   }

	public void addFileAttachment(VoaFileAttachment attachment) {
		Validate.notNull(attachment, "Null attachment specified.");
		getInternalFileAttachments().add(attachment);
		attachment.setVoaApplication(this);
	}

	public void removeAllVoaAttachments() {
		Iterator it = getInternalFileAttachments().iterator();
		//null out reference to parent
		while (it.hasNext())
		{
			((VoaFileAttachment)it.next()).setVoaApplication(null);
		}
		getInternalFileAttachments().clear();
	}
		
	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}



	public String getMiddleName() {
		return middleName;
	}



	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}



	public BigDecimal getPersonId() {
		return personId;
	}



	public void setPersonId(BigDecimal personId) {
		this.personId = personId;
	}



	public VAFacility getPreferredFacility() {
		return preferredFacility;
	}



	public void setPreferredFacility(VAFacility preferredFacility) {
		this.preferredFacility = preferredFacility;
	}



	public Date getReceiveTimeStamp() {
		return receiveTimeStamp;
	}



	public void setReceiveTimeStamp(Date receiveTimeStamp) {
		this.receiveTimeStamp = receiveTimeStamp;
	}



	public Date getResponseTimeStamp() {
		return responseTimeStamp;
	}



	public void setResponseTimeStamp(Date responseTimeStamp) {
		this.responseTimeStamp = responseTimeStamp;
	}



	public String getSsn() {
		return ssn;
	}



	public void setSsn(String ssn) {
		this.ssn = ssn;
	}



	private Set getInternalVOAApplicationData() {
		if (internalVOAApplicationData == null) {
			this.internalVOAApplicationData = new HashSet();
		}
		return this.internalVOAApplicationData;
	}

	private void setInternalVOAApplicationData(Set internalVOAApplicationData) {
		this.internalVOAApplicationData = internalVOAApplicationData;
	}

	public VOAApplicationData getVOAApplicationData() {
		Set appData = getInternalVOAApplicationData();
		if (appData.size() > 0) {
			return (VOAApplicationData) appData.iterator().next();
		}
		return null;
	}

	public void setVOAApplicationData(VOAApplicationData appData) {
		Set ad = getInternalVOAApplicationData();
		ad.clear();
		if (appData != null) {
			ad.add(appData);
			appData.setVoaApplication(this);
		}
	}
	   
	   
	private Set getInternalVOAResubmissionApps() {
		if (internalVOAResubmissionApps == null) {
			this.internalVOAResubmissionApps = new HashSet();
		}
		return this.internalVOAResubmissionApps;
	}

	private void setInternalVOAResubmissionApps(Set internalVOAResubmissionApps) {
		this.internalVOAResubmissionApps = internalVOAResubmissionApps;
	}

	public VOAResubmissionData getVOAResubmissionData() {
		Set appData = getInternalVOAResubmissionApps();
		if (appData.size() > 0) {
			return (VOAResubmissionData) appData.iterator().next();
		}
		return null;
	}

	public void setVOAResubmissionData(VOAResubmissionData appData) {
		Set ad = getInternalVOAResubmissionApps();
		ad.clear();
		if (appData != null) {
			ad.add(appData);
			appData.setVoaApplicationId((BigDecimal)this.getIdentifier());
		}
	}
	   
	   public boolean equals(Object rhs)
	   {
		   
	       if (rhs == null)
	           return false;
	       if (rhs == this)
	    	   return true;
	       if (rhs.getClass() != getClass()) 
	           return false; 

	       
	       VOAApplication that = (VOAApplication) rhs;
	       if (isEqual(this.getIdentifier(), that.getIdentifier()) &&
	    		   isEqual(this.personId,that.personId) &&
	    		   isEqual(this.applicationStatus,that.applicationStatus)  &&
	    		   isEqual(this.internalVOAApplicationData,that.internalVOAApplicationData))
	       {
	           return true;
	       }
	           
	       return false;
	   }
	   
	   private boolean isEqual(Object a, Object b)
	   {
		   if (a == null)
		   {
			   return (b == null) ? true : false;
		   } else
		   {
			   return (b == null) ? false : a.equals(b);
		   }
	   }

	   /**
	    * Implementation of the hashCode method conforming to the Bloch pattern with
	    * the exception of array properties (these are very unlikely primary key types).
	    * @return int
	    */
	   public int hashCode()
	   {
	       if (this.hashValue == 0)
	       {
	           int result = 17;
	           int idValue = this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode();
	           result = result * 37 + idValue;
	           result = result * 37 + this.applicationStatus.hashCode();
	           result = result * 37 + this.ssn.hashCode();
	           if (this.personId != null)
	           {
	        	   result = result * 37 + personId.hashCode();
	           }
	           result = result * 37 + this.applicationStatus.hashCode();
	           if (this.internalVOAApplicationData != null)
	           {
	        	   result = result * 37 + internalVOAApplicationData.hashCode();
	           }
	           this.hashValue = result;
	       }
	       return this.hashValue;
	   }
	   
	   
	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);
		builder.append("formType", this.formType);
		builder.append("applicationStatus", this.applicationStatus);
		builder.append("personId",this.personId);
		builder.append("responseTimeStamp", this.responseTimeStamp);
		builder.append("receiveTimeStamp",this.receiveTimeStamp);
		builder.append("lastName",	this.lastName);
		builder.append("firstName",	this.firstName);
		builder.append("middleName",	this.middleName);
		builder.append("dateOfBirth",	this.dateOfBirth);
		builder.append("ssn",	this.ssn);
		builder.append("gender",	this.gender);
	}	
	
}
