/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 6, 2006
 *
 */
package gov.va.med.esr.common.model.person;

// Java classes
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

// Library classes

// Framework classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// EDB Classes
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.SignatureIndicator;
import gov.va.med.esr.common.model.person.Person;

/**
 * @author Yi He
 * @version 1.0
 */
public class SignatureImage extends AbstractKeyedEntity implements Comparable{
	
	private static final long serialVersionUID = 4682226492346984180L;
    private Date dateIndex;
    private String imageIdNumber;
	private Integer incomeYear;
    private SignatureIndicator signatureIndicator;
    private VAFacility siteSubmittingImage;
    private String user;
    
    private Person person;

    public Date getDateIndex() {
    	return this.dateIndex;
    }
    
    public void setDateIndex(Date dateIndex) {
    	this.dateIndex = dateIndex;
    }
    
    public String getImageIdNumber() {
    	return this.imageIdNumber;
    }
    
    public void setImageIdNumber(String imageIdNumber) {
    	this.imageIdNumber = imageIdNumber;
    }

    public Integer getIncomeYear() {
    	return this.incomeYear;
    }
    
    public void setIncomeYear(Integer incomeYear) {
    	this.incomeYear = incomeYear;    	
    }
    
    public SignatureIndicator getSignatureIndicator() {
    	return this.signatureIndicator;
    }
    
    public void setSignatureIndicator(SignatureIndicator signatureIndicator) {
    	this.signatureIndicator = signatureIndicator;
    }
        
    public VAFacility getSiteSubmittingImage() {
    	return this.siteSubmittingImage; 
    }
    
    public void setSiteSubmittingImage(VAFacility siteSubmittingImage) {
    	this.siteSubmittingImage = siteSubmittingImage;
    }
    
    public String getUser() {
    	return this.user;
    }
    
    public void setUser(String user) {
    	this.user = user;
    }
    
    public Person getPerson() {
        return this.person;
    }
    
    public void setPerson(Person person) {
        validateOwner(this.person, person);
        this.person = person;
    }
	/**
	 * Sort oder to list Indicator Yes first and secondary with modifiedOn
	 */
    public int compareTo(Object o)
    {
    	if (o == null || !(o instanceof SignatureImage)) 
    		return 0;
    	else if (this.equals(o))
    		return 0;
    	else 
    	{
    		SignatureImage oImage = (SignatureImage)o;
    		if (getSignatureIndicator() == null || oImage.getSignatureIndicator() == null)
    			return 0;
    		else if (getSignatureIndicator().getCode().equals(SignatureIndicator.CODE_YES.getName())
    				&& !oImage.getSignatureIndicator().getCode().equals(SignatureIndicator.CODE_YES.getName()))
				return -1;
    		else if (oImage.getSignatureIndicator().getCode().equals(SignatureIndicator.CODE_YES.getName())
    				&& !getSignatureIndicator().getCode().equals(SignatureIndicator.CODE_YES.getName()))
    			return 1;
    		else
	    		return -(this.getModifiedOn().compareTo(oImage.getModifiedOn()));
    	}
    }
    
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);

        builder.append("dateIndex", this.dateIndex);
        builder.append("imageIdNumber", this.imageIdNumber);
        builder.append("incomeYear", this.incomeYear);
        builder.append("signatureIndicator", this.signatureIndicator);
        builder.append("siteSubmittingImage", this.siteSubmittingImage);
        builder.append("user", this.user);

    }    
}

