package gov.va.med.esr.common.model.person;

import java.math.BigDecimal;

import gov.va.med.fw.model.AbstractKeyedEntity;
/**
 * 
 * @author Rajiv Patnaik
 * Created on Mar 8, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SSNVerificationDetail extends AbstractKeyedEntity
{	
    private static final long serialVersionUID = 6386338771178228711L;
    
    private SSNVerification ssnVerification;
    /**
     * Person ID indicates that the SSN Verification is for a vet.
     * The personId is used instead of a person to enhance performance
     * This class is used by the batch process which does not need the 
     * whole person. 
     */
    private BigDecimal personId;
    
    /**
     * SSN ID indicates that the SSN Verification is for a spouse/dependent
     * SSN object is not used to reduce performance overheads.
     */
    private BigDecimal ssnId;
    private String ssnText;
    private String HECInternalId; 
    
    /**
     * @return Returns the hECInternalId.
     */
    public String getHECInternalId()
    {
        return HECInternalId;
    }
    /**
     * @param internalId The hECInternalId to set.
     */
    public void setHECInternalId(String internalId)
    {
        HECInternalId = internalId;
    }
    /**
     * @return Returns the personId.
     */
    public BigDecimal getPersonId()
    {
        return personId;
    }
    /**
     * @param personId The personId to set.
     */
    public void setPersonId(BigDecimal personId)
    {
        this.personId = personId;
    }
    /**
     * @return Returns the ssnId.
     */
    public BigDecimal getSsnId()
    {
        return ssnId;
    }
    /**
     * @param ssnId The ssnId to set.
     */
    public void setSsnId(BigDecimal ssnId)
    {
        this.ssnId = ssnId;
    }
    /**
     * @return Returns the ssnText.
     */
    public String getSsnText()
    {
        return ssnText;
    }
    /**
     * @param ssnText The ssnText to set.
     */
    public void setSsnText(String ssnText)
    {
        this.ssnText = ssnText;
    }
    /**
     * @return Returns the ssnVerification.
     */
    public SSNVerification getSsnVerification()
    {
        return ssnVerification;
    }
    /**
     * @param ssnVerification The ssnVerification to set.
     */
    public void setSsnVerification(SSNVerification ssnVerification)
    {
        this.ssnVerification = ssnVerification;
    }
}
