package gov.va.med.esr.common.model.person;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.AbstractKeyedEntity;
/**
 * 
 * @author Rajiv Patnaik
 * Created on Mar 8, 2006
 * @version 1.0
 * 
 * Copyright  2006 VHA. All rights reserved
 */
public class SSNVerification extends AbstractKeyedEntity
{
    private static final long serialVersionUID = -4997643211189919921L;
    
    private Integer countTotal;
    private Integer countSentToSsa;
    private Date ssaSentDate;
    private Set internalSSNVerificationDetails;
    
    /**
     * @return Returns the countSentToSsa.
     */
    public Integer getCountSentToSsa()
    {
        return countSentToSsa;
    }
    /**
     * @param countSentToSsa The countSentToSsa to set.
     */
    public void setCountSentToSsa(Integer countSentToSsa)
    {
        this.countSentToSsa = countSentToSsa;
    }
    /**
     * @return Returns the countTotal.
     */
    public Integer getCountTotal()
    {
        return countTotal;
    }
    /**
     * @param countTotal The countTotal to set.
     */
    public void setCountTotal(Integer countTotal)
    {
        this.countTotal = countTotal;
    }
    /**
     * @return Returns the ssaSentDate.
     */
    public Date getSsaSentDate()
    {
        return ssaSentDate;
    }
    /**
     * @param ssaSentDate The ssaSentDate to set.
     */
    public void setSsaSentDate(Date ssaSentDate)
    {
        this.ssaSentDate = ssaSentDate;
    }
    
	/**
	 * Returns a collection of SSNVerificationDetail Objects. If no SSNVerificationDetail exists for this
	 * person, this method will return empty Set.
	 * 
	 * @return Set - Set of SSNVerificationDetail , Never NULL
	 */    
	public Set getSSNVerificationDetails() {
		return Collections.unmodifiableSet(getInternalSSNVerificationDetails());
	}
	
	/**
	 * Setter - for hibernate use only.
	 * 
	 * @param SSNVerificationDetails
	 */
	private void setinternalSSNVerificationDetails(Set ssnVerificationDetails) {
		this.internalSSNVerificationDetails = ssnVerificationDetails;
	}
	
	/**
	 * Getter - for hibernate use only.
	 * 
	 * @return
	 */
	private Set getInternalSSNVerificationDetails() {
		if (this.internalSSNVerificationDetails == null) {
			this.internalSSNVerificationDetails = new HashSet();
		}
		return this.internalSSNVerificationDetails;
	}
	
	/**
	 * Add a SSNVerificationDetail for this SSNVerification. This method takes care of Bidirectional
	 * setting of SSNVerificationDetail's SSNVerification object.
	 * 
	 * @param ssnVerificationDetail
	 */
	public void addSSNVerificationDetail(SSNVerificationDetail ssnVerificationDetail) {
		Validate.notNull(ssnVerificationDetail, "Null ssnVerificationDetail specified.");
		getInternalSSNVerificationDetails().add(ssnVerificationDetail);
		ssnVerificationDetail.setSsnVerification(this);
	}

	/**
	 * Remove an SSNVerificationDetail from the SSNVerificationDetail collection. This method
	 * takes care of Bidirectional setting of SSNVerificationDetail's SSNVerification object.
	 * 
	 * @param ssnVerificationDetail
	 */
	public void removeSSNVerificationDetail(SSNVerificationDetail ssnVerificationDetail) {
		Validate.notNull(ssnVerificationDetail, "Null ssnVerificationDetail specified.");
		getInternalSSNVerificationDetails().remove(ssnVerificationDetail);
		ssnVerificationDetail.setSsnVerification(null);
	}	
	
	/**
	 * Remove all SSNVerificationDetails 
	 */
	public void removeAllSSNVerificationDetails() {
		this.getInternalSSNVerificationDetails().clear();
	}	
    
}
