package gov.va.med.esr.common.model.person;


// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework Classes
import gov.va.med.fw.model.AbstractKeyedEntity;

// ESR Classes
import gov.va.med.esr.common.model.lookup.CollectionMethod;
import gov.va.med.esr.common.model.lookup.RaceType;

public class Race extends AbstractKeyedEntity
{     
    /**
     * 
     */
    private static final long serialVersionUID = 6296929534361275665L;

    private Person person = null;
    private RaceType raceType = null;
    private CollectionMethod collectionMethod = null;
    
    /**
     * Creates a new Name object.
     */
    public Race()
    {
        super();
    }

    public Person getPerson()
    {
        return person;
    }

    public void setPerson(Person person)
    {
        validateOwner(this.person, person);
        this.person = person;
    }


    public RaceType getRaceType() {
        return raceType;
    }

    public void setRaceType(RaceType raceType) {
        this.raceType = raceType;
    }

    /**
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
       super.buildToString(builder);
       builder.append("raceType", this.raceType);
       builder.append("collectionMethod", this.collectionMethod);
    }

    public CollectionMethod getCollectionMethod() {
        return collectionMethod;
    }

    public void setCollectionMethod(CollectionMethod collectionMethod) {
        this.collectionMethod = collectionMethod;
    }
}
