package gov.va.med.esr.common.model.person;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.lookup.Language;
import gov.va.med.fw.model.AbstractKeyedEntity;

public class PreferredLanguage extends AbstractKeyedEntity {

    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -69011963002052029L;

    private Person person = null;

    private Language language = null;

    private Date languageEntryDate = null;

    /**
     * Creates a new PreferredLanguage object.
     */
    public PreferredLanguage() {
        super();
    }

    public PreferredLanguage(Language language, Date languageEntryDate, Person person) {
        super();
        this.language = language;
        this.languageEntryDate = languageEntryDate;
        this.person = person;
    }    
    
    public Language getLanguage() {
        return language;
    }


    public Date getLanguageEntryDate() {
        return languageEntryDate;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void setLanguageEntryDate(Date languageEntryDate) {
        this.languageEntryDate = languageEntryDate;
    }

    public Person getPerson() {
        return person;
    }

    public void setPerson(Person person) {
        validateOwner(this.person, person);
        this.person = person;
    }

    /* (non-Javadoc)
     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("language", this.language);
        builder.append("languageEntryDate", this.languageEntryDate);
        builder.append("personvpidValue", this.getPerson() == null ? "" : this.getPerson().getVPIDValue());
        super.buildToString(builder);
    }
}
