package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.model.lookup.SourceDesignation;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

public class PreferredFacilityLite extends AbstractKeyedEntity {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 4732399510509342048L;
	
	private PreferredFacilityPerson personLite = null;
	
	private VAFacility facility = null;
	
	/* Date when this site was assigned as PF - PREFERRED Facility */
	private Date assignmentDate = null;
	
	/* Date when this site was unassigned from being PF - PREFERRED Facility */
	private Date unassignmentDate = null;
	private SourceDesignation sourceDesignation = null;
	    /**
	     * Creates a new PreferredFacility object.
	     */
	    public PreferredFacilityLite()
	    {
	        super();
	    }

	    public PreferredFacilityPerson getPersonLite()
	    {
	        return personLite;
	    }

	    public void setPersonLite(PreferredFacilityPerson personLite)
	    {
	        validateOwner(this.personLite, personLite);
	        this.personLite = personLite;
	    }

	    public VAFacility getFacility() {
		   	return this.facility;
	   }

	   public void setFacility(VAFacility facility) {
		 	this.facility = facility;
	   }
	   

	    /**
	     * @see gov.va.med.fw.model.AbstractKeyedEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	     */
	    protected void buildToString(ToStringBuilder builder)
	    {
	       super.buildToString(builder);
	       builder.append("facility", this.getFacility());
	       builder.append("assignmentDate", this.assignmentDate);
	       builder.append("unassignmentDate", this.unassignmentDate);
	       builder.append("sourceDesignation", this.sourceDesignation);
	    }

		public Date getAssignmentDate() {
			return assignmentDate;
		}

		public void setAssignmentDate(Date assignmentDate) {
			this.assignmentDate = assignmentDate;
		}

		public Date getUnassignmentDate() {
			return unassignmentDate;
		}

		public void setUnassignmentDate(Date unassignmentDate) {
			this.unassignmentDate = unassignmentDate;
		}

		public SourceDesignation getSourceDesignation() {
			return sourceDesignation;
		}

		public void setSourceDesignation(SourceDesignation sourceDesignation) {
			this.sourceDesignation = sourceDesignation;
		}

}
