/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.person;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Abstract relation Object to hold person unmerge data.
 * 
 * @author DNS   CHENJ2
 */
public class PersonUnmergeInfo extends AbstractKeyedEntity {

	private static final long serialVersionUID = 8680621164681570204L;
    
    private Serializable person1Identifier = null;
	private Serializable person2Identifier = null;
	private PersonIdentityTraits	person1IdentityTraits	= null;		// non-persistent data
	private PersonIdentityTraits	person2IdentityTraits	= null;		// non-persistent data
	private String dfn;
	private String stationNumber;

	public PersonIdEntityKey getFromPersonEntityKey() {
		return this.getPerson1EntityKey();
	}
	
	public PersonIdEntityKey getToPersonEntityKey() {
		return this.getPerson2EntityKey();
	}
	

	public void setFromPersonEntityKey(PersonIdEntityKey key) {
		this.setPerson1EntityKey(key);
	}
	
	public void setToPersonEntityKey(PersonIdEntityKey key) {
		this.setPerson2EntityKey(key);
	}
	
	/**
	 * @return Returns the dfn.
	 */
	public String getDfn() {
		return dfn;
	}

	/**
	 * @param dfn The dfn to set.
	 */
	public void setDfn(String dfn) {
		this.dfn = dfn;
	}

	/**
	 * @return Returns the stationNumber.
	 */
	public String getStationNumber() {
		return stationNumber;
	}

	/**
	 * @param stationNumber The stationNumber to set.
	 */
	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}

	private Serializable getPerson1Identifier() {
		return person1Identifier;
	}

	private void setPerson1Identifier(Serializable person1Identifier) {
		this.person1Identifier = person1Identifier;
	}

	public PersonIdentityTraits getPerson1IdentityTraits() {
		return person1IdentityTraits;
	}

	public void setPerson1IdentityTraits(PersonIdentityTraits person1IdentityTraits) {
		this.person1IdentityTraits = person1IdentityTraits;
	}

	private Serializable getPerson2Identifier() {
		return person2Identifier;
	}

	private void setPerson2Identifier(Serializable person2Identifier) {
		this.person2Identifier = person2Identifier;
	}

	public PersonIdentityTraits getPerson2IdentityTraits() {
		return person2IdentityTraits;
	}

	public void setPerson2IdentityTraits(PersonIdentityTraits person2IdentityTraits) {
		this.person2IdentityTraits = person2IdentityTraits;
	}

	// convenience method
	private PersonIdEntityKey getPersonIdEntityKey(Serializable identifier) {
		PersonIdEntityKey key = null;

		if (identifier != null)
        {
            key = CommonEntityKeyFactory.createPersonIdEntityKey(identifier);
        }
 		return key;
	}

	public PersonIdEntityKey getPerson1EntityKey() {
		return getPersonIdEntityKey(getPerson1Identifier());
	}
	
	public void setPerson1EntityKey(PersonIdEntityKey person1EntityKey) {
		if (person1EntityKey != null) {
			setPerson1Identifier(person1EntityKey.getKeyValue());
		}
	}

	public PersonIdEntityKey getPerson2EntityKey() {
		return getPersonIdEntityKey(getPerson2Identifier());
	}
	
	public void setPerson2EntityKey(
			PersonIdEntityKey person2EntityKey) {
		if (person2EntityKey != null) {
			setPerson2Identifier(person2EntityKey.getKeyValue());
		}
	}

	
	protected void buildToString(ToStringBuilder builder) {
	  super.buildToString(builder);
	  builder.append("person1Identifier", this.person1Identifier);
	  builder.append("person2Identifier", this.person2Identifier);
	  builder.append("person1IdentityTraits", this.person1IdentityTraits);
	  builder.append("person2IdentityTraits", this.person2IdentityTraits);
	}

}