/**
 *
 */
package gov.va.med.esr.common.model.person;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.esr.common.model.lookup.SelfIdentifiedGenderIdentity;
import gov.va.med.esr.service.PersonIdentityTraits;

/**
 * @author DNS   KATIKM
 *
 */
public class PersonTraits extends AbstractKeyedEntity {

    private static final long serialVersionUID = -8851818840737926706L;

    private String givenName  = null;
    private String middleName = null;
    private String familyName = null;
    private String ssn = null;
    private String vpid = null;
    private String gender = null;
    private String birthDate = null;
    private SelfIdentifiedGenderIdentity sigi = null;


	public String getFamilyName() {
		return this.familyName;
	}

	public String getGivenName() {
		return this.givenName;
	}

	public String getMiddleName() {
		return this.middleName;
	}

	public String getSsn() {
		return this.ssn;
	}

    public String getVpid() {
        return this.vpid;
    }

    public String getGender() {
        return this.gender;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

	public void setFamilyName(String familyName) {
		this.familyName = familyName;
	}

	public void setGivenName(String givenName) {
		this.givenName = givenName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

    public void setVpid(String VPID) {
        this.vpid = VPID;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public SelfIdentifiedGenderIdentity getSigi() {
		return sigi;
	}

	public void setSigi(SelfIdentifiedGenderIdentity sigi) {
		this.sigi = sigi;
	}

	public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

	public String getFormattedName() {
		StringBuffer buffer = new StringBuffer();
		buffer.append(familyName == null ? "" : familyName + ",");
		buffer.append(givenName == null ? "" : givenName + " ");
		buffer.append(middleName == null ? "" : middleName);
		return buffer.toString();
	}

	public void setTraits(PersonIdentityTraits identityTraits){
		if (identityTraits != null){
			setSsn(identityTraits.getSsn());
			setName(identityTraits.getLegalName());
            setVpid(identityTraits.getVpid().getVPID());
            //setSigi(identityTraits.getSigi());

            if (identityTraits.getGender() != null) {
                setGender(identityTraits.getGender().getCode());
            }

            if (identityTraits.getBirthRecord() != null && identityTraits.getBirthRecord().getBirthDate() != null) {
                setBirthDate(identityTraits.getBirthRecord().getBirthDate().toStandardFormat());
            }
		}
	}

	private void setSsn(SSN ssn){
		if (ssn != null){
			this.ssn = ssn.getSsnText();
		}
	}

	private void setName(Name name) {
		if (name != null) {
			givenName = name.getGivenName();
			middleName = name.getMiddleName();
		    familyName = name.getFamilyName();
		}
	}

	/* (non-Javadoc)
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		// TODO Auto-generated method stub
	}
}
