/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.person;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * Abstract relation Object to hold person merge data.
 * 
 * @author DNS   CHENJ2
 */
public class PersonMergeInfo extends AbstractKeyedEntity {

	private static final long serialVersionUID = 3453931235558751426L;
    private Person primaryPerson=null;
    private Person deprecatedPerson=null;
    private Serializable primaryPersonIdentifier = null;
	private Serializable deprecatedPersonIdentifier = null;
	private Boolean recordLocked = Boolean.FALSE;
    private Date mergeStartDate = null;
    private Date mergeEndDate = null;
    private String mergeSelections = null;

	private PersonIdentityTraits	primaryPersonIdentityTraits			= null;		// non-persistent data
	private PersonIdentityTraits	deprecatedPersonIdentityTraits		= null;		// non-persistent data

	public PersonIdentityTraits getDeprecatedPersonIdentityTraits() {
		return deprecatedPersonIdentityTraits;
	}
	
	public void setDeprecatedPersonIdentityTraits(
			PersonIdentityTraits deprecatedPersonIdentityTraits) {
		this.deprecatedPersonIdentityTraits = deprecatedPersonIdentityTraits;
	}

    public Date getMergeStartDate()
    {
        return mergeStartDate;
    }

    public void setMergeStartDate(Date mergeStartDate)
    {
        this.mergeStartDate = mergeStartDate;
    }

    public boolean isMergeInProgress()
    {
        return getMergeStartDate() != null;
    }

    public Date getMergeEndDate()
    {
        return mergeEndDate;
    }

    public void setMergeEndDate(Date mergeEndDate)
    {
        this.mergeEndDate = mergeEndDate;
    }

    public boolean isMergeCompleted()
    {
        return getMergeEndDate() != null;
    }

    public String getMergeSelections() {
		return mergeSelections;
	}

	public void setMergeSelections(String mergeSelections) {
		this.mergeSelections = mergeSelections;
	}
	
	public PersonIdentityTraits getPrimaryPersonIdentityTraits() {
		return primaryPersonIdentityTraits;
	}
	
	public void setPrimaryPersonIdentityTraits(
			PersonIdentityTraits primaryPersonIdentityTraits) {
		this.primaryPersonIdentityTraits = primaryPersonIdentityTraits;
	}
	
	public Boolean isRecordLocked() {
		return recordLocked;
	}
	
	public Boolean getRecordLocked() {
		return recordLocked;
	}

	public void setRecordLocked(Boolean recordLocked) {
		this.recordLocked = recordLocked;
	}
	
	// convenience method
	private PersonIdEntityKey getPersonIdEntityKey(Serializable identifier) {
		PersonIdEntityKey key = null;

		if (identifier != null)
			key = CommonEntityKeyFactory.createPersonIdEntityKey(identifier);
		return key;
	}


	public PersonIdEntityKey getPrimaryPersonEntityKey() {
		return getPersonIdEntityKey(getPrimaryPersonIdentifier());
	}
	
	public void setPrimaryPersonEntityKey(PersonIdEntityKey primaryPersonEntityKey) {
		if (primaryPersonEntityKey != null) {
			setPrimaryPersonIdentifier(primaryPersonEntityKey.getKeyValue());
		}
	}

	public PersonIdEntityKey getDeprecatedPersonEntityKey() {
		return getPersonIdEntityKey(getDeprecatedPersonIdentifier());
	}
	
	public void setDeprecatedPersonEntityKey(
			PersonIdEntityKey deprecatedPersonEntityKey) {
		if (deprecatedPersonEntityKey != null) {
			setDeprecatedPersonIdentifier(deprecatedPersonEntityKey.getKeyValue());
		}
	}

	private Serializable getPrimaryPersonIdentifier() {
		return primaryPersonIdentifier;
	}

	private void setPrimaryPersonIdentifier(Serializable primaryPersonIdentifier) {
		this.primaryPersonIdentifier = primaryPersonIdentifier;
	}

	private Serializable getDeprecatedPersonIdentifier() {
		return deprecatedPersonIdentifier;
	}

	private void setDeprecatedPersonIdentifier(
			Serializable deprecatedPersonIdentifier) {
		this.deprecatedPersonIdentifier = deprecatedPersonIdentifier;
	}
	
	protected void buildToString(ToStringBuilder builder) {
	  super.buildToString(builder);
	  builder.append("deprecatedPersonIdentifier", this.deprecatedPersonIdentifier);
	  builder.append("primaryPersonIdentifier", this.primaryPersonIdentifier);
	  builder.append("deprecatedPersonIdentityTraits", this.deprecatedPersonIdentityTraits);
	  builder.append("primaryPersonIdentityTraits", this.primaryPersonIdentityTraits);
	  builder.append("recordLocked", this.recordLocked);
	  builder.append("mergeStartDate", this.mergeStartDate);
      builder.append("mergeEndDate", this.mergeEndDate);
	  builder.append("mergeSelections", this.mergeSelections);
	  builder.append("primaryPerson", this.primaryPerson);
	  builder.append("deprecatedPerson", this.deprecatedPerson);
	}

	public Person getPrimaryPerson() {
		return primaryPerson;
	}

	public void setPrimaryPerson(Person primaryPerson) {
		this.primaryPerson = primaryPerson;
	}

	public Person getDeprecatedPerson() {
		return deprecatedPerson;
	}

	public void setDeprecatedPerson(Person deprecatedPerson) {
		this.deprecatedPerson = deprecatedPerson;
	}
}