package gov.va.med.esr.common.model.person;

// Java Classes
import java.io.Serializable;

/**
 * Contains the reason a person is locked.
 */
public class PersonLockedReason implements Serializable
{
    private static final long serialVersionUID = -6377193798977003783L;

    /** Unknown Reason. */
    public static final PersonLockedReason UNKNOWN = new PersonLockedReason("Unknown");

    /** A person merge is currently being worked on. */
    public static final PersonLockedReason PERSON_MERGE_ACTIVE = new PersonLockedReason("Person Merge Active");

    /** A person is deprecated. */
    public static final PersonLockedReason PERSON_DEPRECATED = new PersonLockedReason("Person Deprecated");

    /** There are pending trait updates in PSIM. */
    public static final PersonLockedReason PENDING_IDENTITY_TRAIT_UPDATES =
        new PersonLockedReason("Pending Identity Trait Updates");

    /** A person has no enrollment determincation record (i.e. they are a "shell" record. */
    public static final PersonLockedReason PERSON_NO_ENROLLMENT_DETERMINATION = new PersonLockedReason("No Enrollment Determination");

    // The lock reason
    private String reason;

    /**
     * Objects can only be instantiated by ourselves.
     */
    private PersonLockedReason(String reason)
    {
        super();
        this.reason = reason;
    }

    public boolean equals(Object object)
    {
        // Ensure we have the correct type of object
        if (!(object instanceof PersonLockedReason))
        {
            return false;
        }

        PersonLockedReason lockedReason = (PersonLockedReason)object;
        return this.getReason().equals(lockedReason.getReason());
    }

    public int hashCode()
    {
        return this.reason.hashCode();
    }

    public String toString()
    {
        return this.reason;
    }

    public String getReason()
    {
        return reason;
    }

    public void setReason(String reason)
    {
        this.reason = reason;
    }
}
